//----------------------------------------------------------------------------//
//- CafAdressdaten.pas -------------------------------------------------------//
//----------------------------------------------------------------------------//

//- Beschreibung -------------------------------------------------------------//
// Frame, dass die Adressdaten kapselt                                        //
//----------------------------------------------------------------------------//

unit CafAdressdaten;

//------------------------------------------------------------------------------

interface

//------------------------------------------------------------------------------

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, CaoPersonenListe;

//------------------------------------------------------------------------------

type
  TFrmAdressdaten = class(TFrame)
    m_GrpInitialen     : TGroupBox;
    m_EdtInitialen     : TEdit;
    m_LblInitialen     : TLabel;
    m_GrpAdressdaten   : TGroupBox;
    m_LblVorname       : TLabel;
    m_EdtName          : TEdit;
    m_LblName          : TLabel;
    m_LblStrasse       : TLabel;
    m_EdtStrasse       : TEdit;
    m_LblPlz           : TLabel;
    m_EdtPlz           : TEdit;
    m_LblOrt           : TLabel;
    m_EdtOrt           : TEdit;
    m_EdtVorname       : TEdit;

  //----------------------------------------------------------------------------

  private
    m_ObPerson: TCaoPersonen;

    //--------------------------------------------------------------------------

    procedure PrvLoadData;
    Procedure PrvSaveData;

  //----------------------------------------------------------------------------

  public
    procedure ShowFrame(obPerson: TCaoPersonen);
    Procedure CloseFrame(iModalResult: Integer);

  //----------------------------------------------------------------------------

  end; // TFrmAdressdaten

//------------------------------------------------------------------------------

implementation

//------------------------------------------------------------------------------

{$R *.dfm}

//------------------------------------------------------------------------------

procedure TFrmAdressdaten.ShowFrame(obPerson: TCaoPersonen);
(*
  Initialisieren des Frames.
  Muss im FormShow des Besitzerdialogs aufgerufen werden
*)
begin
  m_ObPerson := obPerson;
  PrvLoadData;
  m_EdtInitialen.SetFocus;  
end; // TFrmAdressdaten.InitFrame

//------------------------------------------------------------------------------

procedure TFrmAdressdaten.PrvLoadData;
(*
  Frame mit Daten abfllen
*)
begin
  m_EdtInitialen.Text := m_obPerson.sInitialen;
  m_EdtVorname  .Text := m_obPerson.sVorname;
  m_EdtName     .Text := m_obPerson.sName;
  m_EdtStrasse  .Text := m_obPerson.sStrasse;
  m_EdtPlz      .Text := m_obPerson.sPlz;
  m_EdtOrt      .Text := m_obPerson.sOrt;
end; // TFrmAdressdaten.PrvLoadData

//------------------------------------------------------------------------------

procedure TFrmAdressdaten.PrvSaveData;
(*
  Daten aus dem Frame im Anbieter-Objekt ablegen
*)
begin
  m_obPerson.sInitialen  := m_EdtInitialen .Text;
  m_obPerson.sVorname    := m_EdtVorname   .Text;
  m_obPerson.sName       := m_EdtName      .Text;
  m_obPerson.sStrasse    := m_EdtStrasse   .Text;
  m_obPerson.sPlz        := m_EdtPlz       .Text;
  m_obPerson.sOrt        := m_EdtOrt       .Text;
end; // TFrmAdressdaten.PrvSaveData

//------------------------------------------------------------------------------

procedure TFrmAdressdaten.CloseFrame(iModalResult: Integer);
(*
  Prozedur, die aufgerufen werden muss, wenn das Frame geschlossen wird
*)
begin
  // Nur wenn der Owner-Dialog nicht mit Cancel verlassen wird, werden dir
  // vernderten Daten in das Personen-Objekt zurckgeschrieben
  if iModalResult <> mrCancel then begin
    PrvSaveData;
  end; // if
end; // TFrmAdressdaten.CloseFrame

//------------------------------------------------------------------------------

end. // CafAdressdaten
